/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.sound;

import bluej.utility.Debug;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;

public class SoundRecorder {
    private AudioFormat format;
    private AtomicBoolean keepRecording = new AtomicBoolean();
    private TargetDataLine line;
    private BlockingQueue<byte[]> recordedResultQueue = new ArrayBlockingQueue<byte[]>(1);
    private byte[] recorded;

    public SoundRecorder() {
        this.format = new AudioFormat(22050.0f, 8, 1, true, true);
    }

    public AtomicReference<List<byte[]>> startRecording() {
        try {
            this.line = (TargetDataLine)AudioSystem.getLine(new DataLine.Info(TargetDataLine.class, this.format));
            this.line.open();
            if (!this.line.getFormat().equals(this.format)) {
                Debug.message((String)("Format is not as expected" + this.line.getFormat().toString()));
            }
            this.line.start();
            this.keepRecording.set(true);
            AtomicReference<Object> partialResult = new AtomicReference<Object>(null);
            Runnable rec = () -> {
                int bufferSize = (int)(this.format.getSampleRate() / 2.0f) * this.format.getFrameSize();
                LinkedList<byte[]> frames = new LinkedList<byte[]>();
                while (this.keepRecording.get()) {
                    byte[] buffer = new byte[bufferSize];
                    int bytesRead = this.line.read(buffer, 0, bufferSize);
                    if (bytesRead != bufferSize) {
                        this.keepRecording.set(false);
                        continue;
                    }
                    frames.addLast(buffer);
                    partialResult.set(new LinkedList<byte[]>(frames));
                }
                partialResult.set(null);
                this.line.stop();
                boolean done = false;
                while (!done) {
                    try {
                        this.recordedResultQueue.put(SoundRecorder.merge(frames));
                        done = true;
                    }
                    catch (InterruptedException interruptedException) {}
                }
            };
            new Thread(rec).start();
            return partialResult;
        }
        catch (LineUnavailableException e) {
            Debug.reportError((String)"Problem capturing sound", (Throwable)e);
            return null;
        }
    }

    public void stopRecording() {
        this.keepRecording.set(false);
        this.recorded = null;
        while (this.recorded == null) {
            try {
                this.recorded = this.recordedResultQueue.take();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.line.close();
    }

    public void writeWAV(File destination) {
        ByteArrayInputStream baiStream = new ByteArrayInputStream(this.recorded);
        AudioInputStream aiStream = new AudioInputStream(baiStream, this.format, this.recorded.length);
        try {
            AudioSystem.write(aiStream, AudioFileFormat.Type.WAVE, destination);
            aiStream.close();
            baiStream.close();
        }
        catch (IOException e) {
            Debug.reportError((String)"Problem writing recorded sound to WAV file", (Throwable)e);
        }
    }

    private static byte[] merge(List<byte[]> frames) {
        int totalLength = 0;
        for (byte[] frame : frames) {
            totalLength += frame.length;
        }
        byte[] result = new byte[totalLength];
        int curOffset = 0;
        for (byte[] frame : frames) {
            System.arraycopy(frame, 0, result, curOffset, frame.length);
            curOffset += frame.length;
        }
        return result;
    }

    public byte[] getRawSound() {
        return this.recorded;
    }

    public void trim(float begin, float end) {
        if (this.recorded != null) {
            float length = this.recorded.length;
            int beginIndex = (int)(begin * length);
            int endIndex = (int)(end * length);
            this.recorded = Arrays.copyOfRange(this.recorded, beginIndex, endIndex);
        }
    }

    public AudioFormat getFormat() {
        return this.format;
    }
}

