/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.actions;

import bluej.Config;
import bluej.utility.Debug;
import greenfoot.core.Simulation;
import greenfoot.event.SimulationEvent;
import greenfoot.event.SimulationListener;
import greenfoot.event.SimulationUIListener;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;

public class RunSimulationAction
extends AbstractAction
implements SimulationListener {
    private static final String iconFile = "run.png";
    private static RunSimulationAction instance = new RunSimulationAction();
    private Simulation simulation;
    protected boolean stateOnDebugResume;
    private SimulationUIListener listener;
    private Runnable actionListener;

    public static RunSimulationAction getInstance() {
        return instance;
    }

    private RunSimulationAction() {
        super(Config.getString("run.simulation"), new ImageIcon(RunSimulationAction.class.getClassLoader().getResource(iconFile)));
    }

    public void attachSimulation(Simulation simulation) {
        this.simulation = simulation;
        simulation.addSimulationListener(this);
    }

    public void attachListener(SimulationUIListener listener) {
        this.listener = listener;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.simulation == null) {
            Debug.reportError((String)"attempt to run a simulation while none exists.");
            return;
        }
        if (this.listener != null) {
            this.listener.simulationActive();
        }
        if (this.actionListener != null) {
            this.actionListener.run();
        }
        this.simulation.setPaused(false);
    }

    @Override
    public void simulationChanged(SimulationEvent e) {
        int eventType = e.getType();
        if (eventType == 1) {
            EventQueue.invokeLater(() -> {
                this.stateOnDebugResume = true;
                this.setEnabled(true);
            });
        } else if (eventType == 0) {
            EventQueue.invokeLater(() -> {
                this.stateOnDebugResume = false;
                this.setEnabled(false);
            });
        } else if (eventType == 3) {
            EventQueue.invokeLater(() -> {
                this.stateOnDebugResume = false;
                this.setEnabled(false);
            });
        } else if (eventType == 5) {
            EventQueue.invokeLater(() -> {
                this.stateOnDebugResume = this.isEnabled();
                this.setEnabled(false);
            });
        } else if (eventType == 6) {
            EventQueue.invokeLater(() -> this.setEnabled(this.stateOnDebugResume));
        }
    }

    public void setActionListener(Runnable actionListener) {
        this.actionListener = actionListener;
    }
}

