/*
 * Decompiled with CFR 0.152.
 */
public abstract class Respawnable
extends Interactable {
    private static final int timeToRespawn = 600;
    private boolean isActive;
    private int timeLeftToRespawn;
    private String imageFile;

    public Respawnable(String theImageFile) {
        this.imageFile = theImageFile;
        this.respawn();
    }

    public boolean isObjectActive() {
        return this.isActive;
    }

    @Override
    public void act() {
        if (!this.isActive) {
            --this.timeLeftToRespawn;
            if (this.timeLeftToRespawn == 0) {
                this.respawn();
            }
        }
    }

    public void respawn() {
        this.isActive = true;
        this.timeLeftToRespawn = 0;
        this.setImage(this.imageFile);
    }

    public void despawn() {
        this.isActive = false;
        this.timeLeftToRespawn = 600;
        this.setImage("empty_25.jpg");
    }

    @Override
    public void interact(Minion theMinion) {
        if (this.isActive) {
            this.despawn();
            this.specificInteract(theMinion);
        }
    }

    public abstract void specificInteract(Minion var1);
}

