/*
 * Decompiled with CFR 0.152.
 */
import greenfoot.Actor;
import java.util.Random;

public abstract class Moving
extends Respawnable {
    private MentalState theMentalState = MentalState.passive;
    private int lurkingTimer = 0;
    private double aggressionRadius;
    private int lurkingMaxTime;
    private int speed;

    public Moving(String theImageFile, double aggressionRadius, int lurkingMaxTime, int speed) {
        super(theImageFile);
        this.aggressionRadius = aggressionRadius;
        this.lurkingMaxTime = lurkingMaxTime;
        this.speed = speed;
    }

    @Override
    public void act() {
        if (!this.getMinion().isGameOver()) {
            super.act();
            if (this.isObjectActive()) {
                this.theMentalState = this.calculateMentalState();
                Random generator = new Random();
                int randomNumber = generator.nextInt(100);
                if (randomNumber < this.speed) {
                    this.move();
                }
            }
        }
    }

    private void move() {
        switch (this.theMentalState) {
            case passive: {
                this.movePassive();
                break;
            }
            case aggressive: {
                this.moveAggressive();
                break;
            }
            case lurking: {
                this.moveLurking();
                break;
            }
        }
    }

    private void movePassive() {
        int yNext;
        Random generator = new Random();
        int xNext = generator.nextInt(3) - 1;
        if (this.canMoveRelative(xNext, yNext = generator.nextInt(3) - 1)) {
            this.moveRelative(xNext, yNext);
        }
    }

    private void moveAggressive() {
        int xDiff = this.getMinion().getX() - this.getX();
        int yDiff = this.getMinion().getY() - this.getY();
        int xRel = 0;
        int yRel = 0;
        if (xDiff < 0) {
            xRel = -1;
        }
        if (xDiff > 0) {
            xRel = 1;
        }
        if (yDiff < 0) {
            yRel = -1;
        }
        if (yDiff > 0) {
            yRel = 1;
        }
        if (this.canMoveRelative(xRel, yRel)) {
            this.moveRelative(xRel, yRel);
        } else {
            this.lurkingTimer = this.lurkingMaxTime;
        }
    }

    private void moveLurking() {
        --this.lurkingTimer;
        this.movePassive();
    }

    private boolean canMoveRelative(int xRelative, int yRelative) {
        if (this.getX() + xRelative >= 23) {
            return false;
        }
        if (this.getY() + yRelative >= 22) {
            return false;
        }
        Actor anObject = this.getOneObjectAtOffset(xRelative, yRelative, Wall.class);
        return anObject == null;
    }

    private void moveRelative(int xRelative, int yRelative) {
        this.setLocation(this.getX() + xRelative, this.getY() + yRelative);
    }

    private MentalState calculateMentalState() {
        if (this.lurkingTimer > 0) {
            return MentalState.lurking;
        }
        if (this.distanceToMinion() > this.aggressionRadius) {
            return MentalState.passive;
        }
        return MentalState.aggressive;
    }

    private double distanceToMinion() {
        int xMinion = this.getMinion().getX();
        int yMinion = this.getMinion().getY();
        double xDiff = this.getX() - xMinion;
        double yDiff = this.getY() - yMinion;
        return Math.sqrt(xDiff * xDiff + yDiff * yDiff);
    }

    private static enum MentalState {
        passive,
        aggressive,
        lurking;

    }
}

