/*
 * Decompiled with CFR 0.152.
 */
import greenfoot.Actor;
import greenfoot.Greenfoot;
import greenfoot.UserInfo;

public class Minion
extends Actor {
    public static final int initHP = 0;
    public static final int maxHP = 100;
    public static final int initScore = 0;
    public static final int maxScore = 300;
    private int healthPoints = 0;
    public int score = 0;
    private boolean gameOver = false;

    public int getHP() {
        return this.healthPoints;
    }

    public void setHP(int newHP) {
        this.healthPoints = newHP;
        if (this.healthPoints > 100) {
            this.healthPoints = 100;
        }
        ((TVPWorld)this.getWorld()).theInfoBoard.updateInfoItem(InfoBoard.InfoItemType.hp, this.healthPoints);
    }

    public void adjustHP(int change) {
        int newHP = this.getHP() + change;
        this.setHP(newHP);
    }

    public int getScore() {
        return this.score;
    }

    public void setScore(int newScore) {
        this.score = newScore;
        if (this.score > 300) {
            this.score = 300;
        }
        ((TVPWorld)this.getWorld()).theInfoBoard.updateInfoItem(InfoBoard.InfoItemType.score, this.score);
    }

    public void adjustScore(int change) {
        int newScore = this.getScore() + change;
        this.setScore(newScore);
    }

    @Override
    public void act() {
        if (!this.gameOver) {
            this.move();
            this.interactWithObject(this.getInteractableObject());
            if (this.isDead()) {
                this.doDeathBehavior();
            }
        }
    }

    private void move() {
        if (Greenfoot.isKeyDown("down") && this.canMoveRelative(0, 1)) {
            this.moveRelative(0, 1);
        }
        if (Greenfoot.isKeyDown("up") && this.canMoveRelative(0, -1)) {
            this.moveRelative(0, -1);
        }
        if (Greenfoot.isKeyDown("right") && this.canMoveRelative(1, 0)) {
            this.moveRelative(1, 0);
        }
        if (Greenfoot.isKeyDown("left") && this.canMoveRelative(-1, 0)) {
            this.moveRelative(-1, 0);
        }
    }

    public boolean canMoveRelative(int xRelative, int yRelative) {
        if (this.getX() + xRelative >= 23) {
            return false;
        }
        if (this.getY() + yRelative >= 22) {
            return false;
        }
        Actor anObject = this.getOneObjectAtOffset(xRelative, yRelative, Wall.class);
        return anObject == null;
    }

    public void moveRelative(int xRelative, int yRelative) {
        this.setLocation(this.getX() + xRelative, this.getY() + yRelative);
    }

    private Interactable getInteractableObject() {
        Actor anObject = this.getOneObjectAtOffset(0, 0, Interactable.class);
        return (Interactable)anObject;
    }

    private void interactWithObject(Interactable theObject) {
        if (theObject != null) {
            theObject.interact(this);
        }
    }

    private boolean isDead() {
        return this.healthPoints < 0;
    }

    private void doDeathBehavior() {
        UserInfo myInfo;
        this.setImage("cross_25.jpg");
        Greenfoot.playSound("death.wav");
        this.gameOver = true;
        ((TVPWorld)this.getWorld()).EndGame();
        if (UserInfo.isStorageAvailable() && this.score > (myInfo = UserInfo.getMyInfo()).getScore()) {
            myInfo.setScore(this.score);
            myInfo.store();
        }
    }

    public boolean isGameOver() {
        return this.gameOver;
    }
}

