/*
 * Decompiled with CFR 0.152.
 */
import greenfoot.Actor;
import greenfoot.GreenfootImage;
import java.awt.Color;

public class Clock
extends Actor {
    private int startingTime;
    private int seconds = 60;
    private int clockType = 0;
    private long lastCurrentSecond;
    private long timeSaved = 0L;
    private boolean timeUp = false;
    private boolean count = false;
    private boolean displayTime;
    private boolean countDown;
    private String text;

    public Clock(boolean countDown, boolean displayTime, int startingTime, String text) {
        this.countDown = countDown;
        this.displayTime = displayTime;
        this.startingTime = startingTime;
        this.text = text;
        this.seconds = startingTime;
        this.getImage().clear();
        if (!countDown) {
            this.seconds = 60;
        }
        if (displayTime) {
            this.getImage().scale(130, 70);
        }
        this.startClock();
    }

    @Override
    public void act() {
        if (this.countDown) {
            if (this.count && !this.timeUp) {
                if (System.currentTimeMillis() - this.lastCurrentSecond >= 1000L) {
                    this.lastCurrentSecond += 1000L;
                    --this.seconds;
                    if (this.displayTime) {
                        this.drawTime();
                    }
                }
                if (this.seconds == 0) {
                    this.timeUp = true;
                }
                if (this.timeUp) {
                    ((TVPWorld)this.getWorld()).EndGame();
                }
            }
        } else if (this.count && System.currentTimeMillis() - this.lastCurrentSecond >= 1000L) {
            this.lastCurrentSecond += 1000L;
            ++this.seconds;
            if (this.displayTime) {
                this.drawTime();
            }
        }
    }

    private void drawTime() {
        int min = this.seconds / 60;
        int sec = this.seconds % 60;
        String remainingTime = sec < 10 ? min + ":0" + sec : min + ":" + sec;
        this.getImage().setColor(Color.gray);
        this.getImage().fill();
        GreenfootImage text = new GreenfootImage(this.text == null ? "" : this.text, 30, Color.black, new Color(0, 0, 0, 0));
        GreenfootImage time = new GreenfootImage(remainingTime, 40, Color.black, new Color(0, 0, 0, 0));
        if (text.getWidth() > this.getImage().getWidth()) {
            this.getImage().clear();
            this.getImage().scale(text.getWidth() + 10, 70);
            this.getImage().setColor(Color.gray);
            this.getImage().fill();
        }
        this.getImage().drawImage(text, this.getImage().getWidth() / 2 - text.getWidth() / 2, 5);
        this.getImage().drawImage(time, this.getImage().getWidth() / 2 - time.getWidth() / 2, this.text == null ? this.getImage().getHeight() / 2 - time.getHeight() / 2 : 30);
    }

    public boolean timeUp() {
        return this.timeUp;
    }

    public void startClock() {
        this.lastCurrentSecond = System.currentTimeMillis() - this.timeSaved;
        this.count = true;
    }
}

